(function ($) {
    'use strict';
    var VisualBeyBladeAnimation = {
        initFog: function () {
            elementorFrontend.hooks.addAction('frontend/element_ready/section', VisualBeyBladeAnimation.initBeyBladeWidget);
        },
        initBeyBladeWidget: function ($scope) {
            var sectionId = $scope.data('id');
            var target = '.elementor-element-' + sectionId;
            var settings = {};
            if (window.isEditMode || window.elementorFrontend.isEditMode()) {
                var editorElements = null;
                var beyBladeAnimationArgs = {};

                if (!window.elementor.hasOwnProperty('elements')) {
                    return false;
                }

                editorElements = window.elementor.elements;

                if (!editorElements.models) {
                    return false;
                }

                $.each(editorElements.models, function (i, el) {
                    if (sectionId === el.id) {
                        beyBladeAnimationArgs = el.attributes.settings.attributes;
                    } else if (el.id === $scope.closest('.elementor-top-section').data('id')) {
                        $.each(el.attributes.elements.models, function (i, col) {
                            $.each(col.attributes.elements.models, function (i, subSec) {
                                beyBladeAnimationArgs = subSec.attributes.settings.attributes;
                            });
                        });
                    }
                    settings.switch = beyBladeAnimationArgs.marvy_enable_beyblade_animation;
                    settings.block_scroll = beyBladeAnimationArgs.marvy_enable_beyblade_animation_block_scroll_touch;

                    settings.line_count = beyBladeAnimationArgs.marvy_beyblade_animation_line_count;
                    settings.line_width = beyBladeAnimationArgs.marvy_beyblade_animation_line_width;
                    settings.circle_radius = beyBladeAnimationArgs.marvy_beyblade_animation_circle_radius;
                    settings.rotation_speed = beyBladeAnimationArgs.marvy_beyblade_animation_rotation_speed;

                    settings.line_count_tablet = beyBladeAnimationArgs.marvy_beyblade_animation_line_count_tablet;
                    settings.line_width_tablet = beyBladeAnimationArgs.marvy_beyblade_animation_line_width_tablet;
                    settings.circle_radius_tablet = beyBladeAnimationArgs.marvy_beyblade_animation_circle_radius_tablet;
                    settings.rotation_speed_tablet = beyBladeAnimationArgs.marvy_beyblade_animation_rotation_speed_tablet;

                    settings.line_count_mobile = beyBladeAnimationArgs.marvy_beyblade_animation_line_count_mobile;
                    settings.line_width_mobile = beyBladeAnimationArgs.marvy_beyblade_animation_line_width_mobile;
                    settings.circle_radius_mobile = beyBladeAnimationArgs.marvy_beyblade_animation_circle_radius_mobile;
                    settings.rotation_speed_mobile = beyBladeAnimationArgs.marvy_beyblade_animation_rotation_speed_mobile;

                    settings.color_type = beyBladeAnimationArgs.marvy_beyblade_animation_color_type;
                    settings.color_single = beyBladeAnimationArgs.marvy_beyblade_animation_color_single;
                    settings.color_multiples = beyBladeAnimationArgs.marvy_beyblade_animation_color_multiples;
                });

            } else {
                settings.switch = $scope.data("marvy_enable_beyblade_animation");
                settings.block_scroll = $scope.data("marvy_enable_beyblade_animation_block_scroll_touch");

                settings.line_count = $scope.data("marvy_beyblade_animation_line_count");
                settings.line_width = $scope.data("marvy_beyblade_animation_line_width");
                settings.circle_radius = $scope.data("marvy_beyblade_animation_circle_radius");
                settings.rotation_speed = $scope.data("marvy_beyblade_animation_rotation_speed");

                settings.line_count_tablet = $scope.data("marvy_beyblade_animation_line_count_tablet");
                settings.line_width_tablet = $scope.data("marvy_beyblade_animation_line_width_tablet");
                settings.circle_radius_tablet = $scope.data("marvy_beyblade_animation_circle_radius_tablet");
                settings.rotation_speed_tablet = $scope.data("marvy_beyblade_animation_rotation_speed_tablet");

                settings.line_count_mobile = $scope.data("marvy_beyblade_animation_line_count_mobile");
                settings.line_width_mobile = $scope.data("marvy_beyblade_animation_line_width_mobile");
                settings.circle_radius_mobile = $scope.data("marvy_beyblade_animation_circle_radius_mobile");
                settings.rotation_speed_mobile = $scope.data("marvy_beyblade_animation_rotation_speed_mobile");

                settings.color_type = $scope.data("marvy_beyblade_animation_color_type");
                settings.color_single = $scope.data("marvy_beyblade_animation_color_single");
                settings.color_multiples = $scope.data("marvy_beyblade_animation_color_multiples");
            }

            if (settings.switch) {
                beyBladeAnimation(target, settings, sectionId);
            }
        }
    };

    function beyBladeAnimation(target, mainSettings, sectionId) {

        var checkElement = document.getElementsByClassName("marvy-beyblade-section-" + sectionId);
        if (checkElement.length >= 0) {

            // Canvas Setup
            var beyblade_div = document.createElement('canvas');
            beyblade_div.classList.add("marvy-beyblade-section-" + sectionId);

            document.querySelector(target).appendChild(beyblade_div);
            document.querySelector(target).classList.add("marvy-custom-beyblade-animation-section-" + sectionId);

            // Set Z-index for section container
            var beybladeZindex = document.querySelector('.marvy-custom-beyblade-animation-section-' + sectionId + ' .elementor-container');
            beybladeZindex.style.zIndex = '99';

            // Set min height
            var beybladeMinHeight = document.querySelector(".elementor-element-" + sectionId);
            beybladeMinHeight.closest('.elementor-top-section').style.minHeight = "100px";
            // Canvas Setup End


            // --------------------------------------------------------------------------------------------------------------------------


            // Value Setup
            var settings = mainSettings;
            settings.color_multiples = settings.color_multiples.split("--,--");
            var beyCanvas = document.querySelector(".marvy-beyblade-section-" + sectionId); // canvas
            let targetStyle = getStyle(document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId));
            beyCanvas.width = parseInt(targetStyle['width']);
            beyCanvas.height = parseInt(targetStyle['height']);
            var beyCanvasContex = beyCanvas.getContext('2d'); // canvas contex
            var eles = [];
            let rect = document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId).getBoundingClientRect();
            var m = {
                x: rect.left,
                y: rect.top
            };

            document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId).onmousemove = function (e) {
                let rect = document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId).getBoundingClientRect();
                m.x = e.pageX - rect.left;
                m.y = (e.pageY - rect.top - window.scrollY);
            }

            document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId).ontouchstart = function (e) {
                if(settings.block_scroll == 'yes'){
                    e.preventDefault();
                }
                let rect = document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId).getBoundingClientRect();
                m.x = e.pageX - rect.left;
                m.y = (e.pageY - rect.top - window.scrollY);
            }

            document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId).ontouchmove = function (e) {
                if(settings.block_scroll == 'yes'){
                    e.preventDefault();
                }
                let mv = e.changedTouches[e.changedTouches.length-1];
                let rect = document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId).getBoundingClientRect();

                m.x = mv.pageX - rect.left;
                m.y = mv.pageY - rect.top - window.scrollY;
            }

            beyCanvasResize(mainSettings,beyCanvas, beyCanvasContex, settings, eles, sectionId);
            animateBeyblade(beyCanvas, beyCanvasContex, eles, settings, m);

            window.addEventListener('resize', function (event) {
                eles = [];
                beyCanvasResize(mainSettings,beyCanvas, beyCanvasContex, settings, eles, sectionId);
            }, true);

            $(document).ready(function () {
                beyCanvasResize(mainSettings,beyCanvas, beyCanvasContex, settings, eles, sectionId);
            });

            window.dispatchEvent(new Event('resize'));
        }

    }

    function scaleByPixelRatio(input) {
        let pixelRatio = window.devicePixelRatio || 1;
        if (isMobile()) {
            pixelRatio = 1;
        }
        return Math.floor(input * pixelRatio);
    }

    function getStyle(el) {
        return (typeof getComputedStyle !== 'undefined' ?
                getComputedStyle(el, null) :
                el.currentStyle
        );
    }

    function animateBeyblade(beyCanvas, beyCanvasContex, eles, settings, m) {
        beyCanvasContex.fillStyle = "rgba(0,0,0,0.05)"; // background + opacity
        beyCanvasContex.fillRect(0, 0, beyCanvasContex.canvas.width, beyCanvasContex.canvas.height);
        eles.forEach(function (e, i) {
            e.dr(beyCanvasContex, m);
        });
        requestAnimationFrame((time) => animateBeyblade(beyCanvas, beyCanvasContex, eles, settings, m));
    }

    function beyCanvasResize(mainSettings,beyCanvas, beyCanvasContex, settings, eles, sectionId) {
        settings = beyChangeSettings(mainSettings,settings);
        let targetStyle = getStyle(document.querySelector(".marvy-custom-beyblade-animation-section-" + sectionId));
        beyCanvas.width = parseInt(targetStyle['width']);
        beyCanvas.height = parseInt(targetStyle['height']);
        beyCanvasContex = beyCanvas.getContext('2d');
        for (var i = 0; i < settings.line_count; i++) {
            let r = 30;
            let x = Math.random() * (innerWidth - 2 * r) + r;
            let y = Math.random() * (innerHeight - 2 * r) + r;
            // a[i] = new ob(innerWidth / 2,innerHeight / 2,4,gc(),Math.random() * 200 + 20,0.02);
            let color = gc();
            switch (settings.color_type) {
                case 'single':
                    color = settings.color_single;
                    break;
                case 'multiple':
                    color = settings.color_multiples[Math.floor(Math.random() * (settings.color_multiples.length))];
                    break;
            }
            eles[i] = new beyDraw(beyCanvasContex, innerWidth / 2, innerHeight, settings.line_width, color, settings.rotation_speed, settings.circle_radius);
        }
    }

    function beyChangeSettings(mainSettings,settings){
        if(window.innerWidth > 1023){
            settings.line_count = mainSettings.line_count;
            settings.line_width = mainSettings.line_width;
            settings.circle_radius = mainSettings.circle_radius;
            settings.rotation_speed = mainSettings.rotation_speed;
        }else if(window.innerWidth <= 1023 && window.innerWidth > 767){
            settings.line_count = mainSettings.line_count_tablet;
            settings.line_width = mainSettings.line_width_tablet;
            settings.circle_radius = mainSettings.circle_radius_tablet;
            settings.rotation_speed = mainSettings.rotation_speed_tablet;
        } else {
            settings.line_count = mainSettings.line_count_mobile;
            settings.line_width = mainSettings.line_width_mobile;
            settings.circle_radius = mainSettings.circle_radius_mobile;
            settings.rotation_speed = mainSettings.rotation_speed_mobile;
        }
        return settings;
    }

    function beyDraw(beyCanvasContex, x, y, r, cc, s, cr) {
        this.x = x;
        this.y = y;
        this.r = r;
        this.cc = cc;
        this.theta = Math.random() * Math.PI * 2;
        this.s = s;
        this.t = Math.random() * (cr * 2);

        this.dr = function (beyCanvasContex, m) {
            const ls = {
                x: this.x,
                y: this.y
            };
            this.theta += this.s;
            this.x = m.x + Math.cos(this.theta) * this.t;
            this.y = m.y + Math.sin(this.theta) * this.t;
            beyCanvasContex.beginPath();
            beyCanvasContex.lineWidth = this.r;
            beyCanvasContex.strokeStyle = this.cc;
            beyCanvasContex.moveTo(ls.x, ls.y);
            beyCanvasContex.lineTo(this.x, this.y);
            beyCanvasContex.stroke();
            beyCanvasContex.closePath();
        }
    }

    //random color generator
    function gc() {
        var s = "0123456789ABCDEF";
        var c = "#";
        for (var i = 0; i < 6; i++) {
            c += s[Math.ceil(Math.random() * 15)]
        }
        return c
    }

    function isMobile() {
        return /Mobi|Android/i.test(navigator.userAgent);
    }

    $(window).on('elementor/frontend/init', VisualBeyBladeAnimation.initFog);
})
(jQuery);